//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.19 Page 300
  //Title: Sizing of an airfoil
  //===================================================================
model Ex8_19
import SI=Modelica.SIunits;

//parameter section
parameter Real cl=0.5 "The lift coefficient of the airfoil";
parameter Real f(unit = "kgf")=50 "The lift in kg force";
parameter SI.Velocity v=150/3.6;
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter SI.Acceleration g=9.8 "The acceleration due to gravity ";

//variable section
SI.Length c "The length of the chord of the foil";
SI.Force f_N "The lift in Newtons";
Real d "The drag coefficient";
Real l_d_ratio "The lift by drag ratio";
Real cd(unit ="kgf") "The viscous drag per unit span";

//equation section
equation
//conversion of kgforce to newtons
f_N=f*g;
//from the lift coefficient equation eq8.90
c=f_N/(rho_air*0.5*v*v*cl);
//to estimate the drag we look at figure 8.38 
d=0.005;
l_d_ratio=cl/d;
cd=0.5;
end Ex8_19;
//===================================================================
