//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.22 Page 310
  //Title: Effect of aspect ratio
  //===================================================================
model Ex8_22
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter Real a(unit = "Degree")=5 "The angle at which the wings are inclined";
parameter SI.Length c=0.5 "The chord length of both wings";
parameter SI.Length b1=2 "The span of one wing";
parameter SI.Length b2=4 "The span of the second wing";

//variable section
Real ar1 "The aspect ratio of first wing";
Real ar2 "The aspect ratio of second wing";
Real cla1 "The lift slope of first wing";
Real cla2 "The lift slope of second wing";
Real cl_1 "The lift coefficient of first wing";
Real cl_2 "The lift coefficient of second wing";
Real cdi_1 "The induced drag of first wing";
Real cdi_2 "The induced drag of second wing";
Real l_d_1 "The lift to drag ratio of first wing";
Real l_d_2 "The lift to drag ratio of seconnd wing";

//equation section
equation
//the aspect ratios of the two wings
ar1=b1/c;
ar2=b2/c;
//the lift slopes
cla1=2*pi/(1+(2/ar1));
cla2=2*pi/(1+(2/ar2));
//the lift coefficients
cl_1=cla1*8*pi/180;
cl_2=cla2*8*pi/180;
//the induced drags are
cdi_1=1/(pi*ar1)*cl_1*cl_1;
cdi_2=1/(pi*ar2)*cl_2*cl_2;
// the lift to induced drag ratios
l_d_1=cl_1/cdi_1;
l_d_2=cl_2/cdi_2;
//clearly the higher the aspect ratio the wing is more efficient
end Ex8_22;
//===================================================================
//Error in the book: Due to a calculation mistake in the value of lift coefficient for the second wing
//the cl_2should be 0.701 instead of 0.599, hence cdi_2 should be 0.019 instead of 0.014. therefore, l_d_2=35.8 instead of 42.78
