//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.24 Page 312
  //Title: Hydrofoil boat
  //===================================================================
model Ex8_24
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter SI.Length b=4 "The wing span of the hydrofoil";
parameter SI.Length c=0.5 "The length of the chord";
parameter Real a(unit = "Degree")=5 "The angle at which the water flows";
parameter Real rho_water(unit = "kg/m3")=1030 "The density of the water";
parameter SI.Velocity u=12 "The velocity of the foil";
parameter SI.Area s=2 "The area of one hydrofoil"; 

//variable section
Real ar "The aspect ratio";
Real cla "The lift slope";
Real cl "The lift coefficient";
SI.Force w "The weight of the boat";
Real cdi "The induced drag coefficient";
SI.Force di "The induced drag force";
SI.Power p "The power required for overcoming the induced gas";
Real p_hp(unit = "hp") "The power required in horse power";

//equation section
equation
//aspect ratio is 
ar=b/c;
//the lift slope
cla=2*pi/(1+2/ar);
//the lift coefficient
cl=cla*a*pi/180;
//we take the combined area of the foil and desnity of sea water is taken from table 1.1
w=cl*0.5*rho_water*u*u*(s+s);
cdi=1/(pi*ar)*cl*cl;
di=cdi*0.5*rho_water*u*u*(s+s);
//power required for the induced drag
p=di*u;
p_hp=p/745.6;//conversion to hp
//about 37 hp
end Ex8_24;
//variation: p_hp=36.551 hp according to the simulation while it is about 37 hp as mentioned in the book
//===================================================================
