//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number Flow over Bodies(Incompressible)
  //Example: 8.6 Page 280
  //Title: Darg due to skin friction only
  //===================================================================
model Ex8_6

//parameter section
parameter Real Re=3*(10)^6 "The reynolds number for the flow";

//variabble section
Real cd1 "The disharge coefficient for single side";
Real cd "The discharge coefficient for two sides";
Real cd_t "The discharge coefficient for the turbulent flow";
Real cd_l "The discharge coefficient for the laminar flow";

//equation section
equation
//from the figure 8.21 we assume that flow is attached adn drag is a result of skin friction only
//the drag coefficient is estimayed from the boundary layer data of figure 7.10
cd_t=0.004;
//fro laminar flow we use the blasius equation
cd_l=2*0.664/(Re)^0.5;
//based on shape of pressure distribution the gradient is favorable for 40percent of the length
//we assume that flow is laminar for 40 percent and the rest is turbulent
cd1=0.4*cd_l+0.6*cd_t;//for single side
cd=2*(0.4*cd_l+0.6*cd_t);//estimated for two sieds
//this value is closely matching with the result for airfoil
end Ex8_6;
//===================================================================
