//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.7 Page 281
  //Title: Drag of a pole
  //===================================================================
model Ex8_7
import SI=Modelica.SIunits;

//parameter section 
parameter SI.Length l=15 "The length of the pole";
parameter SI.Length d=0.25 "The diameter of the pole";
parameter SI.Velocity u=30 "The velcoity of the wind";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter Real mu_air(unit = "Ns/m2")=1.81*10^(-5) "The dynamic viscosity of air";

//variable section
Real Re "The reynolds number for the flow";
Real cd "The drag coefficient";
SI.Force D "The total drag force";
Real m(unit = "Nm") "The moment at the base";

//equation section
equation
Re=rho_air*u*d/mu_air;
//in this reynold's nummber the flow is turbulent and the drag coefficient is 0.7 from the figure 8.19
cd=0.7;
D=cd*0.5*rho_air*u*u*d*l;
//we assume that the total drag acts halfway to the top
m=l/2*D;
end Ex8_7;
//===================================================================
