//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.8 Page 281
  //Title: Terminal Velocity of a sphere
  //===================================================================
model Ex8_8
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1);//the value of pi

//parameter section
parameter SI.Length d=0.005 "The diameter of aluminium ball";
parameter Real rho_al(unit = "kg/m3")=2700 "The density of aluminium";
parameter Real rho_oil(unit  ="kg/m3")=919 "The density of oil";
parameter SI.Acceleration g=9.8 "The acceleartion due to gravity";
parameter Real mu_oil(unit = "Ns/m2")=0.29 "The dynamic viscosity of oil";

//variable section
SI.Velocity u "The sinking speed of the aluminium ball";
Real Re "The reynolds number for the flow";

//equation section
equation
//*here we assume that Re is less than 4 hence we use stokes formula cd=24/Re *
//force pulling the ball down is the weight minus the buoyancy
//(rho_al-rho_oil)*vol_ball*g=(rho_al-rho_oil)*4/3*(d/2)^3*g
// the upward force acting is the resistance to this motion
//d=cd*0.5*rho_oil*u*u*(pi*r*r)=6pi*mu_oil*u
//equating the upward anf downward forces
u=2/(9*mu_oil)*(rho_al-rho_oil)*g*(d/2)^2;
Re=rho_oil*u*d/mu_oil;
//thus the assumption did at the beginning is reasonable
end Ex8_8;
//sinking speed given in the book=0.084 m/s
//sinking speed through simulation=0.083591 m/s
//===================================================================
