//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010

//Chapter-1:Basic Concepts And Fluid Properties
//Example: 1.1 Page 09
//Title: Density of air and volume of air
//===================================================================

model Ex1_1
//=============
// Parameter Section 

parameter Real univ_gas_const(unit = "m2/(s2K)")=8314.3 "Universal gas constant";
//assuming molecular mass of air=29g/mol
parameter Real mol_mass_air(unit = "g/mol")=29 "molecular mass of air";

parameter Real air_temp(unit = "K")=300 "Temperature of air";

//=============
// Variable Section 
Real air_pressure(unit = "N/m2")=9.8*10^4 "Pressure of air";
Real air_pressure2(unit = "N/m2")=101300 "Pressure of air";
Real rho_air(unit = "Kg/m3");
Real vol_air(unit = "m3")"Volume of air";
//=============
// Equation Section 

equation
rho_air = air_pressure*mol_mass_air/(univ_gas_const * air_temp);
//since individual gas constant=univ_gas_const/mol_mass_air
//since volume of air is calculated for 1gram of air unive_gas_const is multiplied by a factor of 0.001 to convert gram to kg
vol_air=univ_gas_const*0.001*air_temp/air_pressure2;
end Ex1_1;
//===================================================================
