//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010

//Chapter-1:Basic Concepts And Fluid Properties
//Example: 1.2 Page 11
//Title: Shear stress 
//===================================================================

model Ex1_2
//parameter section
parameter Real oil_thickness(unit = "m")=0.02 "Thickness of oil";
parameter Real oil_velocity(unit = "m/s")=3 "Velocity of oil layer";
//taking the standard value of viscosity of oil at 20 degreee C
parameter Real oil_viscosity(unit = "kg/m s")=0.293 "Viscosity of oil";

//variable section
Real oil_shear(unit = "N/m2") "Shear stress of oil layer";

//equation section
equation
oil_shear = oil_viscosity*(oil_velocity / oil_thickness);
end Ex1_2;
//The calculated value of oil_shear=43.95 kg/ms. there has been a slight variation in the book.
//===================================================================
