model Ex1_7
  //Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-1:Basic Concepts And Fluid Properties
  //Example: 1.7 Page 17
  //Title: Speed of sound in air and water
  //===================================================================
  //parameter section
  //Assuming air to be an ideal gas
  parameter Real heat_cap_ratio = 1.4 "Heat capacity ratio";
  parameter Real gas_const(unit = "m2/(s2K)") = 286.6 "Gas constant for air";
  parameter Real modulus_of_elasticity(unit = "N/m2") = 2.34 * 10 ^ 9 "Modulus of elasticity of water";
  parameter Real rho_water(unit = "kg/m3") = 1000 "Density of seawater";
  
  //variable section
  Real temp(unit = "K") = 300 "Temperature";
  Real speed_air(unit = "m/s") "speed of air";
  Real speed_water(unit = "m/s") "speed of water";
  
  //equation section
equation
  speed_air = (heat_cap_ratio * gas_const * temp) ^ 0.5;
  speed_water = (modulus_of_elasticity / rho_water) ^ 0.5;
end Ex1_7;
//===================================================================
