//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-10:Elements of Inviscid compressible flow
  //Example: 10.5 Page 354
  //Title: Flow through converging-diverging nozzle
  //===================================================================
model Ex10_5
import SI=Modelica.SIunits;
parameter Real p0(unit = "atm")=4 "The stagnation pressure";
parameter Real t0(unit = "K")=300 "The temperature at stagnation condition";
parameter SI.Area at=5*10^(-4) "The throat area";
parameter SI.Area ae=0.001 "The exit area";

//variable section
Real p1(unit = "atm") "The pressure at the exit in case 1";
Real p_ratio "The pressure ratio";
Real m1 "The mach number";
Real a_ratio "The ratio of exit area to critical area";
SI.Area a "The critical area";
Real at_ratio "The ratio of throat area to critical area";
Real a_et "The ratio between exit and throat areas for case 2";
Real a_e "The ratio between exit and critical areas for case 2";
Real m2 "The mach number for case 2 obtained from appendix B in the book";
Real p_ratio2 "Th ratio of pressure obtained from the appendix B in the book";
Real p2(unit = "atm")"The pressure in the case 2";
Real a_et2 "The raio of exit and throat area for case 3";
Real a_e2 "The ratio of exit and critical area for case 3";
Real m2_2 "The mach number for case 3";
Real p_ratio3 "The ratio of the p3 to p0";
Real p3(unit = "atm") "The pressure in the case 3";

//equation section
equation
//case 1:
p1=3.8;
p_ratio=p1/p0;
//from the appendix B in the book we get m1=0.26 abd ae/a=2.32
m1=0.26;
a_ratio=2.32;
a=ae/a_ratio;
//this area a is smaller than throat area and we can calculate the area ratio at the throat 
at_ratio=at/a;
//therefore the mach number at the throat is mt=0.64 -this can be calculated using equation 10.31 also but the algebra is complex
//case 2:
//when the pressure is lowered to a level at which a sonic speed is reached at throat.
//therefore throat area is equal to the critical area
a_et=2;// "The "from the appendix B
a_e=2;//from the appendix B
//for this ratio at the exit we get m2=0.3 and p_raio2=0.939
m2=0/3;
p_ratio2=0.939;
p2=p_ratio2*p0;
//the velocity becomes sonic
//case 3:
a_et2=2;//from the appendix B
a_e2=2;//from the appendix B
//from the supersonic part we get m2_2=2.2 p3/p0=0.094
m2_2=2.2;
p_ratio3=0.094;
p3=p_ratio3*p0;

end Ex10_5;
//===================================================================
