//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-10:Elements of Inviscid compressible flow
  //Example: 10.6 Page 362
  //Title: Thrust of a small control rocket
  //===================================================================
model Ex10_6
import SI=Modelica.SIunits;

//parameter Section
parameter Real t0(unit = "K")=2100 "The temperature at stagnation condition";
parameter Real p0(unit = "atm")=3.5 "The pressure at the stagnation condition";
parameter SI.Area at=4*10^(-4) "The throat area";
parameter Real a_et=4 "The exit to throat area ratio";
parameter Real pa(unit = "atm")=1 "The pressure on the earth";
parameter Real r(unit = "m2/(s2K)")=286.6 "The gas constant";
parameter Real x=1.4 "The ratio of specific heats";

//variable section
Real me "The mach number at exit";
Real p_ratio1 "The ratio of exit to stagnation pressure";
Real t_ratio1 "The ratio of exit to stagnation temperature";
Real pe(unit = "atm") "The exit pressure in atm";
Real pe_Pa(unit = "Pa")"The exit pressure in pascals";
Real te(unit = "K") "The exit temperature";
Real rho_e(unit = "kg/m3") "The exit density";
SI.Area ae "The exit area";
SI.Velocity ue "The exit velocity";
SI.Force fx "The thrust in space";
Real pa_Pas(unit = "Pascals") "The atmospheric pressure in pascals";
Real me2 "The mach number in normal shock case";
Real p_ratio2 "The pressure ratio between p02/p01";
Real a_1c "The area ratio between area1 and critical area";
Real me3 "The mach number in subsonic section";
Real a_1cc "The ratio between area1 and the second critical area";
Real a_ecc "The ratio between exit area and second critical area";
Real m3 "The mach number in subsonic section";
Real p_ratio3 "The pressure ratio of exit and pressure in second case";
Real t_ratio3 "The temperature ratio between exit temperature and temperature in second case";
Real pe2(unit = "atm") "The pressure in the second case";
Real te2(unit = "K")"The temperature in the second case";
SI.Velocity ue2 "The exit velocity in second case";
Real pe_Pa2(unit = "Pascals") "The pressure in the second case in Pascals";
Real rho_e2(unit = "kg/m3") "The exit density in the second case";
SI.Force fx2 "The thrust in the second case";

//equation section
equation
//by using the tables from appendix B we get for isentropic flow
me=2.94;
p_ratio1=0.03;
t_ratio1=0.366;
pe=p_ratio1*p0;
pa_Pas=pa*10^5;
te=t_ratio1*t0;
//the exit velocity can be calculated as 
ue=me*(x*r*te)^0.5;
pe_Pa=pe*10^5;
rho_e=pe_Pa/(r*te);
ae=a_et*at;
//to calculate thrust we use equation 2.29
fx=(rho_e*ue*ue*ae)+(pe_Pa-0)*ae;
//case 2: when thrust of the same unit at sea level is investigated
//the normal shock occurs at lower mach number
//the iterative process begins with guessing the location of the shock and then calculating the pressure at the exit.
//if resulting exit is too high a stronger shock is guessed next.
//for simplicity we let us present only the final iteration and assume the normal shock is in the section where me1=2.9.
//Based on this assumption the normal shock tables in appendix C provides the values
me2=0.481;
p_ratio2=0.358;
//the location of section a1 must be identified.from the isentropic tables a1/ac=3.85
a_1c=3.85;
//next the location at the subsonic side is explored by use of subsonic tables
m3=0.481;
a_1cc=1.38;
//here a_cc is the throat area flow behind the shock wave
a_ecc=1.433;
me3=0.45;
p_ratio3=0.87;
t_ratio3=0.961;
pe2=p0*p_ratio3*p_ratio2;
te2=t_ratio3*t0;
//the exit velocity is then calculated as
ue2=me3*(x*r*te2)^0.5;
pe_Pa2=pe2*10^5;
rho_e2=pe_Pa2/(r*te2);
fx2=(rho_e2*ue2*ue2*ae)+(pe_Pa2-pa_Pas)*ae; 
end Ex10_6;
//variation: fx=219.82 N through book
//           fx=220.097 N through simulation
//===================================================================
