//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.11 Page 421
  //Title: The pelton wheel
  
model Ex11_11
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter SI.Length r=0.1 "The average radius of the pelton wheel";
parameter Real w(unit = "RPM")=1000 "The rotation speed of the pelton wheel";
parameter SI.Velocity c2=30 "The exit velocity of a water jet";
parameter SI.Area a=2*10^(-4) "The area of cross section of the jet";
parameter Real b3(unit = "Degree")=60 "The angle of flow leaving the blade";
parameter Real a2(unit = "Degree")=90 "The nozzle angle";
parameter Real rho(unit = "kg/m3")=1000 "The density of water";

//variable section
Real w_rps(unit = "rps") "The rotation speed in rps";
SI.Velocity u "The blade tip velocity";
SI.Velocity w2 "The velocity relative to thee blade";
SI.Velocity w3 "The exit velocity of the turbine";
SI.Velocity del_c "The change in tangential velocity";
SI.MassFlowRate m "The mass flow rate";
SI.Torque t "The torque produced";
SI.Power p"The power produced";

//equation section
equation
//becuase this is a pelton turbine the velocity relative to the blade (w2) is the difference between the jet and the wheel tip speeds
//this is shown in figure 11.40 c
w_rps=w/60;
u=r*2*pi*w_rps;
w2=c2-u;
//since it is an impulse turbine the exit velocity is unchanged
w3=w2;
//the torque and the power can be calculated with eq 11.69 and 11.70
//the change in tangential velocity is 
del_c=w2*(1+sin(b3*pi/180));
//the mass flow rate is calculated as
m=rho*c2*a;
//the torque and power are calculated as follows
t=m*r*del_c;
p=m*u*del_c;
end Ex11_11;
//variation p=2289.16 W through book
//          p=2289.58 W through simulation
//===================================================================
