//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.12 Page 426
  //Title: Sizing of a wind turbine
  //===================================================================
model Ex11_12
import SI = Modelica.SIunits;
final constant Real pi = 2 * Modelica.Math.asin(1.0);//the value of pi
  
//parameter section
parameter Real p_kW(unit = "kW")=5 "The power produed by the turbine in kW";
parameter SI.Velocity u = 30 / 3.6 "The average wind speed in m/s";
parameter Real np = 0.7 "The efficiency of the turbine";
parameter Real rho(unit = "kg/m3") = 1.22 "The density of air";
  
//variable section
SI.Power p "The power produced in Watts";
SI.Length r "The diameter of the wind turbine";
  
  //equation section
equation
//based on the equation 11.96
//p=np*8/27*rho*u*u*u*pi*r*r;
p=p_kW*1000;
r=(p*27/(8*np*rho*u*u*u*pi))^0.5;
end Ex11_12;
//===================================================================
