//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.2 Page 389
  //Title: Pressure Rise in an Axial Compressor
  //===================================================================
model Ex11_2
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter SI.Velocity cz=120 "The axial velocity across the third stage of the axial compressor";
parameter SI.Length r=0.5 "The average radius";
parameter Real t01(unit = "K")=300 "The stagnation temperature ahead of the rotor";
parameter Real w(unit = "RPM")=4000 "The rotation of thee compressor";
parameter Real a(unit = "Degree")=22 "The stator angle";
parameter Real b(unit = "Degree")=27 "The angle at which the flow leaves the rotor";
parameter Real n_stage=0.98 "The stage efficiency";
parameter Real cp(unit = "kCal/(kg Celcius)")=0.24 "The specific heat";
parameter Real x=1.4 "The ratio of specific heat";

//variable section
SI.Velocity u "The tip speed";
Real w_rps(unit = "rps") "The rotating speed in rps";
SI.Velocity del_c "The velocity vector difference";
Real cp_1(unit = "J/(kg Celcius)") "The specific heat in Joules";
Real p_ratio "The compression ratio";

//equation section
equation
w_rps=w/60;
u=2*pi*r*w_rps;
//now thee velocity triangle is constructed as shown in figure 11.15
//with velocity triangle being constructed the pressure rise can be calculated . first del_c is calculated
del_c=u-(cz*(tan(a*pi/180)+tan(b*pi/180)));
//1kCal=4200 Joules
cp_1=cp*4200;
p_ratio=(1 + ((n_stage*u*del_c)/(cp_1*t01)))^(x/(x-1));
end Ex11_2;
//===================================================================
