//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.3 Page 395
  //Title: Effect of radial variations
  //===================================================================
model Ex11_3
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter Real b_12(unit = "Degree")=15 "The angle at which the blade turns the flow";
parameter SI.Length r1 =0.5 "The tip radius";
parameter SI.Length r2=0.2 "The hub radius";
parameter Real w(unit = "RPM")=5500 "The rotation speed";
parameter SI.Velocity cz=120 "The axial velocity";
parameter Real t(unit = "K")=350 "The air temperature";
parameter Real x=1.4 "The ratio of specific heats";
parameter Real nc=0.98 "The stage efficiency";
parameter Real cp(unit = "kCal/(kg celcius)")=0.24 "The specific heat";
Real r(unit = "m2/(s2K)")=286.6 "The gas constant";

//variable section
SI.Velocity u_hub "The velocity of the hub";
SI.Velocity u_tip "The tip velocity";
Real w_rps(unit = "rps") "The rotational speed in rps";
SI.Velocity w1 "The tip velocity";
SI.Velocity a1 "The speed of sound";
Real m1 "The local mach number";
Real b1(unit = "Degree") "The blade angle";
Real b2(unit = "Degree") "The second blade angle";
Real Cp "The pressure coefficient with hub velocity";
Real del_c(unit = "m/s") "The difference in the tangential velocity in hub case";
Real cp_j(unit = "J/kg(Celcius)") "The specific heat in joules";
Real p_ratio1 "The compression ratio";
Real b1_tip(unit = "Degree") "The blade angle in the tip velocity";
Real b2_tip(unit = "Degree") "The second blade angle in the tip velocity ";
Real Cp_tip "The pressure rise coefficient with tip velocity";
Real del_c_tip(unit = "m/s") "The difference in tangential velocity with tip velocity";
Real p_ratio2 "The compression ratio with tip velocity";

//equation section
equation
w_rps=w/60;
u_hub=2*pi*r2*w_rps;
u_tip=2*pi*r1*w_rps; 
//the velocity triangles can be constructed because there is no turning blade ahead of rotor. thiss is shown in the figure 11.21
//by connecting the U vector and with c1 vector , we identify the incoming velocity and its direction
//we obtain the velocity w2  by simply reducing the angle by 15 degrees
w1=(u_tip*u_tip + cz*cz)^0.5;
a1=(x*r*t)^0.5;
//the local mach number is calculated
m1=w1/a1;
//this is slightly less than the limit started in equation 11.40
//once the velocity triangles are constructed the pressure rise coeefficient is calculated
b1= Modelica.Math.atan(u_hub/cz)*180/pi;
b2=b1-b_12;
Cp=1-(cos(b1*pi/180)/cos(b2*pi/180))^2;
//to calculate the compression ratio the tangential velocity change is calculated based on velocity triangle geometry
del_c=u_hub-(cz*tan(b2*pi/180));
//the compression ratio is then
cp_j=cp*4200;
p_ratio1=(1+(nc*u_hub*del_c)/(cp_j*t))^(x/(x-1));
//now the same process is repeated to the rotor tip
b1_tip=Modelica.Math.atan(u_tip/cz)*180/pi;
b2_tip=b1_tip-b_12;
Cp_tip=1-(cos(b1_tip*pi/180)/cos(b2_tip*pi/180))^2;
//this is near the stall
del_c_tip=u_tip-(cz*tan(b2_tip*pi/180));
p_ratio2=(1+((nc*u_tip*del_c_tip)/(cp_j*t)))^(x/(x-1));
end Ex11_3;
//===================================================================
