//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.4 Page 397
  //Title: Effect of changing the axial velocity
  //===================================================================
model Ex11_4
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter Section
//these assumptions are made with the flow conditions in the second stage of the jet engine
parameter SI.Length r=0.5 "The radius at the second stage";
parameter SI.Velocity cz=140 "The axial velocity";
parameter Real w(unit = "RPM")=4000 "The rotational speed";
parameter Real t(unit = "K")=300 "The stagnation temperature";
parameter Real a(unit = "Degree")=20 "The incoming velocity angle";
parameter Real Cp=0.45 "The pressure rise coefficient for this stage";
parameter Real nc=0.98 "The stage efficiency";
parameter Real x=1.4 "The ratio of specific heats";
parameter Real cp(unit = "kCal/(kg celcius)")=0.24 "The specific heat";

//variable section
Real w_rps(unit = "rps") "The rotation speed in rotation per second";
SI.Velocity u "The rotaion speed in m/s";
Real b1(unit = "Degree") "The first blade angle";
Real b2(unit = "Degree") "The second blade angle";
SI.Velocity del_c "The change in tangential velocity";
Real p_ratio1 "The compression ratio";
Real cp_j(unit = "J/(kg celcius)") "The cp in Joules";
Real a1(unit = "Degree") "The velocity angle in second case";
SI.Velocity cz2 "The axial velocity in the second case";
Real del_a(unit = "Degree") "The angle by which the stator head has to be turned";
SI.Velocity del_c2 "The change in tangential velocity in second case";
Real p_ratio2 "The compression ratio in second case";

//equation section
equation
w_rps=w/60;
u=r*2*pi*w_rps;
//since the axial velocity and the evelocity angle are known the velocity triangle 
//for the rotor inlet can be drawn and the angle b1 can be calculated
b1=Modelica.Math.atan((u-cz*tan(a*pi/180))/cz)*180/pi;
//since the pressure rise coefficient is given we can find b2 also from equation 11.39 in the book
b2=Modelica.Math.acos((cos(b1*pi/180)^2/(1-Cp))^0.5)*180/pi;
//to calculate the compression ratio first we find the difference in tangential velocity 
del_c=u-(cz*(tan(a*pi/180)+tan(b2*pi/180)));
cp_j=cp*4200;
p_ratio1=(1+((nc*u*del_c)/(cp_j*t)))^(x/(x-1));
//the second part 
//the axial velocity is reduced to 100m/s . if no action is taken
//then there will be a significant increase in angle of attack. to avoid such angle of attack b1 should be maintained as such
//this is accomplished by turning the stator head by adjusting the incoming angle a(Refer figure 11.22) 
cz2=100;
a1=Modelica.Math.atan((u-(cz2*tan(b1*pi/180)))/cz2)*180/pi;
//therefore the stator head must be rotated by an angle of del_a as shown
del_a=a1-a;
//to calculate compression ratio we find the change in tangential velocity
del_c2=u-(cz2*(tan(a1*pi/180)+tan(b2*pi/180)));
p_ratio2=(1+((nc*u*del_c2)/(cp_j*t)))^(x/(x-1));
end Ex11_4;
//===================================================================
