//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-11:Fluid Machinery
  //Example: 11.8 Page 414
  //Title: Blade angle and the velocity of the axial turbine
  
model Ex11_8
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//the value of pi

//parameter section
parameter SI.Area a=3*10^(-4) "The cross sectional area of water jet";
parameter Real m(unit = "kg/s")=15 "The mass flow rate of the flow";
parameter Real a2(unit = "Degree")=68.5 "The nozzle angle";
parameter SI.Length r=0.3 "The average radius of the turbine blades";
parameter SI.Mass m1=100 "The mass lifted by the pulley";
parameter Real w(unit = "RPM")=1000 "The rotation rate";
parameter Real rho(unit = "kg/m3")=1000 "The density of water";
parameter SI.Acceleration g=9.8 "The acceleration due to gravity";

//variable section
Real w_rps(unit = "Rps") "The rortation rate in rps";
SI.Velocity u "The blade tip speed";
SI.Velocity c2 "The nozzle velocity";
SI.Velocity cz "The axial velocity";
Real b2(unit = "Degree") "The rotor inlet angle ";
SI.Power p "The power of the turbine";
SI.Velocity v "The velocity required by the pulley";

//equation section
equation
w_rps=w/60;
//the blade tip speed is calculated 
u=2*pi*r*w_rps;
//the nozzle velocity can be calculated with continuity equation
c2=m/(rho*a);
//knowing the tip speed and the nozzle velocity we can draw the velocity triangle as shown in figure 11.34 c
//b2 is then calculated easily based on tirangle trigonometry
cz=c2*cos(a2*pi/180);//axial velocity
//rotor inlet angle is
b2=Modelica.Math.atan((c2*sin(a2*pi/180)-u)/cz)*180/pi;
//this angle is shown in figure 11.34 b
//the power of the turbine is calculated with eq11.72
p=m*u*(2*cz*tan(b2*pi/180));
//the velocity required is 
v=p/(m1*g);
end Ex11_8;
//===================================================================
