 //Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-1:Basic Concepts And Fluid Properties
  //Example: 2.3 Page 43
  //Title: Conservation of Mass
  //===================================================================
model Ex2_3
import SI= Modelica.SIunits;
import Modelica.SIunits.Conversions.*;

//parameter section
parameter SI.Area a1=from_cm2(30) "inlet pipe area";
parameter SI.Area a3=from_cm2(20) "outet pipe 2 area";
parameter SI.Area a2=from_cm2(20) "outlet pipe 1 area";
parameter SI.Velocity u1=1 "inlet pipe velocity";
parameter SI.Velocity u3=1.2 "outlet pipe 2 velocity";
parameter SI.Density rho_water=1000 "Density of water";

//variable section
SI.Velocity u2 "velocity of outlet pipe 1";
SI.MassFlowRate m1 "Mass flow rate of inlet pipe";
SI.MassFlowRate m2 "Mass flow rate of outlet pipe 1";
SI.MassFlowRate m3 "Mass flow rate of outlet pipe 2";

//equation scetion
equation
//by using equation 2.26
m1=rho_water*a1*u1;
m3=rho_water*a3*u3;
m2=m1-m3;//to find the mass flow rate of outlet pipe 1
u2=m2/(rho_water*a2);

end Ex2_3;
//===================================================================

