//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-3:Fluid Statics
  //Example: 3.1 Page 71
  //Title: Hydrostatic pressure variation in a compressible fluid 
  //===================================================================

 model Ex3_1
 import SI=Modelica.SIunits;
 import Modelica.SIunits.Conversions.*;
 
 //parameter section
 parameter SI.Acceleration g=9.81 "Acceleration due to gravity";
 //Assuming air with a density of 1.22kg/m3 to be present at a temperature of 300K.
 parameter SI.Temperature t=300 "Temperature of air";
 parameter SI.Pressure p1=1.01325"Atmospheric pressure";
 parameter Real gas_const(unit = "m2/(s2K)")=286.6;
 parameter SI.Density rho_air=1.22 "Density of air";
 //Assuming that we are at height of 380m
 parameter SI.Length h=380 "Height of the building";
 
 //variable section
 SI.Pressure p2 "Pressure at height 380m";
 //formula 1: p2=p1*exp(-g*h/(t*gas_const));
 //formula 2:pressure_diff2=rho_air*g*h;
 Real pressure_diff (unit = "Pa") "Pressure difference through formula 1";
 Real pressure_diff2 (unit = "Pa")"Pressure difference through formula 2";
 
 //equation section
equation
p2=p1*exp(-g*h/(t*gas_const));
pressure_diff=from_bar(p1-p2);
pressure_diff2 =rho_air*g*h;
end Ex3_1;
//===================================================================

