 //Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-1:Introduction to fluid in motion-one dimensional flow
  //Example: 4.2 Page 115
  //Title: Force on a wedge
  //===================================================================
model Ex4_2
import SI=Modelica.SIunits;

//parameter section
parameter SI.Velocity u1=15 "The velocity of circular water jet";
parameter SI.Diameter d=0.1 "The diameter of the jet";
final Real pi=2*Modelica.Math.asin(1);//value of pi
//Assuming no changes in pressure and the velocity at the exits in figure 4.6 remains to be the same
//the angle between the two jet streams is 60 degrees. this is obtained from the figure 4.6
parameter SI.Density rho_water=1000 "The density of water";

//variable section
SI.Force fx "The force on the x direction";
SI.Area a=pi*(d^2)/4;
SI.Force fz "The force on the z direction";

//equation section
equation
fx=rho_water*(u1^2)*a*(cos(pi/3)-1);
//the vertical components of the momentum equation cancel each other
fz=0;
end Ex4_2;
//===================================================================

