//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.10 Page 174
  //Title: Flow in a pipe with two different diameters
  //===================================================================
model Ex5_10
import SI=Modelica.SIunits;
import SI.Modelica.SIunits.Conversions.*;

//parameter section
parameter SI.Length tot_h=20 "The fluid level in the main tank";
parameter SI.Length d1=0.3 "The diameter of the pipe for the first 50 metres";
parameter SI.Length d2=0.2 "The diameter of the pipe for the rest of the length";
parameter Real k=0.1 "The loss coefficient for the contraction of thee pipe";
parameter SI.Length l1=50 "The length upto which the diameter is 0.3m";
parameter SI.Length l2=100 "The length upto which the diameter is 0.2";
parameter Real f=0.015 "The friction factor for the two pipes used";
parameter SI.Acceleration g=9.8 "The acceleration due to gravity";
parameter Real rho_fl(unit = "kg/m3")=1000 "The density of the fluid is taken from table 1.1 in the book";
parameter Real mu_fl(unit = "Ns/m2")=0.001 "The viscosity is also taken from the table 1.1 in thee book";
final Real pi=2*Modelica.Math.asin(1);//the value of pi

//variable section
SI.Velocity u1 "The velocity through 0.3m diameter pipe";
SI.Velocity u2 "The velocity through 0.2m diameter pipe";
Real q(unit = "m3/s") "The discharge flow rate";
Real Re "Th reynolds number for the flow";

//equation section
equation
//applying Bernoulli's equation to the enitre section of the pipe
//we get :
//p1/(rho*g)+ tot_h+ 0= 0+ p1/(rho*g)+ u2^2/(2*g)+ hf
//here hf can be written as:
//hf=f*l1*u1^2/(d1*2*g) + k*u1^2/(2*g) + f*l2*u2^2/(d2*2*g)
//using continuity  equation we obtain relation between u1 and u2 as
//rho*u1*a1 =  rho*u2*a2
//therefore , u1 = u2*d2*d2/(d1*d1);
u2=(tot_h*2*g/(1+(f*l1/d1*(d2/d1)^4)+ (k*(d2/d1)^4) +(f*l2/d2)))^0.5;
u1=u2*d2*d2/(d1*d1);
//th corresponding flow rate
q=pi*d2*d2*u2/4;
Re=rho_fl*u2*d2/mu_fl;
//Since the reynolds number is very high the flow is turbulent and the friction factor estimation is reasonable
end Ex5_10;
//Error with the units:q is defined as the flow rate of water both in the book and in this code
//                     Hence the SI unit of q(Volumetric flow rate)  is metre cube per second(m3/s)
//                     this is wrongly printed as metre per second in the book.This is changed to m3/s in this code
//Error with calculation of Re: calculated velocity u2= 6.59 m/s but u2 substituted in the book is u2=7.73 m/s
//                              this is an error. Hence Re= 1.318 *10^6 instead of Re=1.346*10^6 as given in the book 
//===================================================================
