//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5: Incompressible flow:Exact solutions
  //Example: 5.11 Page 176
  //Title: Pump Power requirements
  //===================================================================
model Ex5_11
import SI=Modelica.SIunits;

//parameter section
parameter SI.Length l=20 "The total length of the pipe";
parameter Real d_cm(unit = "cm")=6 "The diameter of the pipe given";
parameter Real d_m(unit = "m")=d_cm/100 "The diameter of pipe in metre";
parameter Real q(unit = "m3/s")=7.63*10^(-3) "The desirable flow rate through the pipe";
parameter Real rho_oil(unit = "kg/m3")=900 "The density of the oil";
parameter Real mu_oil(unit = "Ns/m2")=0.18 "The dynamic viscosity of the oil";
final constant Real pi=2*Modelica.Math.asin(1.0);//3.14159265358979
parameter SI.Acceleration g=9.8 "The accelerationd due to gravity";

//variable section
SI.Velocity u1 "The velocity at point 1 in the section of the pipe"; //*REFER FIGURE 5.23FOR ALL EXPLANATIONS*
SI.Velocity u2 "The velocity at point 2 in the section of the pipe";
SI.Area s "The cross sectional area of the pipe";
Real Re "The reynolds number for the flow";
Real f "The internal friction factor";
SI.Length hf "The frictional head loss";
SI.Pressure del_p "The pressure difference between the two points 1 and 2";
SI.Length del_p_h "Pressure head between the two points 1 and 2";
SI.Power p "The total power required by the pump";
Real p_hp(unit = "hp") "The power required in horse power";

//equation section
equation
s=pi*d_m*d_m/4;
//caclculating the velocity at points 1 and 2 of the pipe
u1=q/s;
u2=q/s;
//Now we calculate the reynolds number in order to decide the friction factor
Re=rho_oil*u1*d_m/mu_oil;
//since this value is less than 2100 the flow is laminar
//f=64/Re for laminar flow
f=64/Re;
hf=f*l*u2*u2/(d_m*2*g);
//Using the Bernoulli's equato]ion for the flow between points 1 and 2
//0+ p1/(rho_oil*g)+ u1^2/(2*g) = lsin(40)+ p2/(rho_oil*g)+ u2^2/(2*g)+ hf
//here we take only the vertical component of the length into consideration
//bringign p2 to the left side of the eqaution
//we write del_p=p1-p2
del_p_h=l*sin(pi/180*40)+hf;
del_p=del_p_h*rho_oil*g;
p=del_p*q;
p_hp=p/745.6;//which is close to 2
end Ex5_11;
//power in hp comes out to be p_hp=2.044 hp
//===================================================================
