//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5: Incompressible flow:Exact solutions
  //Example: 5.16 Page 191
  //Title: Head loss in a hydraulic jump
  //===================================================================
model Ex5_16
import SI=Modelica.SIunits;

//parameter section 
SI.Velocity u=8 "The velocity in the water channel";
SI.Acceleration g=9.8 "The acceleration due to gravity";
SI.Length h=1 "The water column height before hydraulic jump";

//variable section
Real fr "The froud's number";
SI.Length h2 "The height of the column because of hydraulic jump ";
SI.Length h2_1 "one of the two solutions";
SI.Length h2_2 "one of the two solutions";
SI.Velocity u2 "The average velocity after jump";
Real fr2 "The Froude's number behind the jump";
SI.Length hf "The head loss in meters";
Real percent_loss "The percentage loss in head";

//equation section
equation
fr=u/(g*h)^0.5;
//based on this Fr value we can classify this as a weak hydraulic jump
//from figure 5.36. therefore we use the equation 5.151 which is derived on page 190
h2_1=(-1+(1+(8*fr*fr))^0.5)/2;
h2_2=(-1-(1+(8*fr*fr))^0.5)/2;
if h2_1>=0 then
h2=h2_1;
else 
h2=h2_2;
end if;
//we find  the average velocity after jump usoing continuity equation
u2=u*h/h2;
fr2=u2/(g*h2)^0.5;
//this fr value belongs to the subcritical range.Hence head loss is calculated using equation 5.152 from page 190
hf=h*(1-(h2/h)+(fr*fr/2*(1-(h/h2)^2)));
// the percentage of loss is then calculated with equation 5.154 on page 191
percent_loss=hf/(h+(u^2/(2*g)))*100;
end Ex5_16;
//===================================================================
