//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.17 Page 194
  //Title: Flow measurement by a weir
  //===================================================================
model Ex5_17
import SI=Modelica.SIunits;

//parameter section
parameter SI.Length w=0.5 "The width of weir";
parameter SI.Length h=0.5 "The height of weir";
//the figure is shown in fig 5.38 (a)
parameter SI.Length d=1 "The depth ahead of the weir";
SI.Acceleration g=9.8 "The acceleration due to gravity";

//variable section
Real cd "The discharge coefficient";
Real q(unit = "m3/s") "The flow rate accross the weir";

//equation section
equation
// the cd is given by the equation 5.158
cd=0.399+(0.0598*w/h);
//the flow rate is given by equation 5.157
q=cd*w*(2*g)^0.5*h^1.5;
end Ex5_17;
//q from the book=0.358 m3/s
//simulated q=0.359 m3/s
//===================================================================
