//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.4 Page 157
  //Title: Lift of a linear bearing
  //===================================================================

model Ex5_4
import SI=Modelica.SIunits;

//parameter section
parameter SI.Length l=0.01 "The length of the magnetic pick up";
parameter SI.Velocity u=50 "The velocity of the magnetic pickup";
parameter SI.Length h1=0.2*10^(-3) "The allowed gap";
parameter SI.DynamicViscosity mu=1.8*10^(-5) "The dynamic viscosity of air";

//variable section
Real lift (unit = "N/m")"The lift of the linear bearing";
Real d_by_f "The draag to lift ratio";

//equation section 
equation
//the formula for lift is obtained from the equation given in page 156 Eq5.66
lift=0.16*mu*u*(l/h1)^2;
// the equation for the ratio is also derived and obtained as Eq5.67 in page 156;
d_by_f=4.7*h1/l;
end Ex5_4;
//===================================================================
