//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.6 Page 165
  //Title: Pressure loss in terms of head loss
  //===================================================================
model Ex5_6
import SI=Modelica.SIunits;

//parameter section
parameter SI.Length l=10 "The length of the pipe";
parameter SI.Length d=0.02 "The diameter of the pipe";
parameter SI.Velocity v=0.15 "The velocity of water flow";
parameter Real rho_water(unit = "kg/m3")=1000 "The density of water";
parameter SI.DynamicViscosity mu=0.001 "The viscosity of water";
parameter SI.Acceleration g=9.81 "The acce;eration due to gravity";

//variable section 
Real re "The reynolds number";
Real frict_fact "The friction factor";
SI.Length hf "The head loss in m of H2O";

//equation section
equation
re=rho_water*v*d/mu;
frict_fact=64/re;
hf=frict_fact*0.5*l*(v^2)/(g*d);
end Ex5_6;
 //===================================================================
