//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.6 Page 165
  //Title: Pressure loss in terms of head loss
  //===================================================================
model Ex5_7
import SI=Modelica.SIunits;

//parameter section
parameter SI.VolumeFlowRate q=10^(-4) "The volumetric flow rate";
parameter SI.Length d=0.03 "The diameter of the pipe";
parameter Real k=0.32 "The loss coefficient due to elbow";
parameter Real rho_water(unit = "kg/m3")=1000 "The density of water";
parameter SI.Acceleration g=9.8 "The acceleration due to gravity";
final Real pi=2*Modelica.Math.asin(1);//value of pi

//variable section
SI.Area s "The cross sectional area of the pipe";
SI.Velocity u_av "The average velocity of water through pipe";
SI.Length hf "The head loss due to elbow";
Real p_diff(unit = "N/m2") "The pressure difference due to head loss";

//equation section
equation
s=pi/4*d^2;
u_av=q/s;
hf=k*u_av^2/(2*g);
p_diff=hf*rho_water*g;
end Ex5_7;
//===================================================================
//simulated hf=0.00032676
//hf in the book=0.000324
