//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-5:Viscous Incompressible flow:Exact solutions
  //Example: 5.8 Page 172
  //Title: Pressure losses in a long pipe
  //===================================================================
model Ex5_8
import SI=Modelica.SIunits;
import Modelica.SIunits.Conversions.*;
parameter SI.Length h_fluid= 20 "The height of the fluid column above the base line";
parameter SI.Length h_base = 2 "The height of the elevation";
parameter SI.Length id=0.3 "The inner diameter of the pipe";
parameter Real inner_coeff=0.015 "The inner resistance coefficient";
parameter Real loss_coeff = 0.3 "The loss coefficient of the elbow";
parameter Real rho_kero (unit = "kg/m3")=804 "The density of kerosene";
parameter Real mu_kero (unit = "Ns/m2")=1.9*10^(-3);
parameter SI.Acceleration g=9.8 "The acceleration due to gravity";
final Real pi=2*Modelica.Math.asin(1);

//variable section
SI.Length tot_h "The height of liquid plus elevation";
SI.Velocity u2 "The discharge velocity";
SI.VolumeFlowRate q2 "The volumetric flow rate at discharge";
Real Re "The reynolds number for the flow";
SI.Length hf2 "The head loss in meters";
SI.Length hk "The height available as kinetic energy";
SI.Velocity u2ch "Revaluating thee discharge velocity through kinetic head";

//equation section
equation
tot_h=h_fluid+h_base;
//Applying Bernoulli's equation to the long pipe
//tot_h+  (p1/(rho_kero*g))+  0 = (p1/(rho_kero*g))+   u2^2/(2*g)+   hf 
//we find that the pressure head is the same . 
//there is no potential head 
//the final equation : tot_h = hf+  u2^2/(2*g);
//hf=inner_coeff*(tot_h/id)*u2^2/(2*g) + 2*loss_coeff*(u2^2)/(2*g);
u2=(tot_h*2*g/(1+(inner_coeff*tot_h/id)+2*loss_coeff))^0.5;
q2=u2*pi*(id^2)/4;
Re=rho_kero*u2*id/mu_kero;
hf2=u2^2/(2*g)*((inner_coeff*tot_h/id)+2*loss_coeff);
hk=tot_h-hf2;
u2ch=(2*g*hk)^0.5;
end Ex5_8;
//Error in the calculation in the book .tThe total height has been taken wrongly in the calculation of hf as 202 instead of 22//
//simulated answer u2=12.6374 metres per second
//===================================================================
