//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.1 Page 265
  //Title: Velocity induced by a source
  //===================================================================
model Ex8_1
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1);//the value of pi

//parameter section
parameter Real sigma(unit = "m^2/s")=5 "The strength of the source";
parameter Real x=0 "The x coordinate at which velocity has to be found";
parameter Real z=-1 "The z coordinate at which velocity has to be found";
parameter Real x0=1 "The x coordinate of the source";
parameter Real z0=1 "The z coordinate of the source";

//variable section
SI.Velocity u ;
SI.Velocity v ;
//u and v are the components of the velocity
SI.Length r "The value of the distance vector";

//equation section
equation
r=((x-x0)^2+(z-z0)^2)^0.5;
u=sigma/(2*pi)*((x-x0)/r^2);//ref equation 8.39
v=sigma/(2*pi)*((z-z0)/r^2);//ref equation 8.40
end Ex8_1;
//===================================================================
