//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.13 Page 286
  //Title: Power requirement for a cruising automobile
  //===================================================================
model Ex8_13
import SI=Modelica.SIunits;

//parameter section
parameter Real cd=0.32 "The drag coefficient of the sports car";
parameter SI.Area s=1.8 "The frontal area of the car";
parameter SI.Velocity u=100/3.6 "The velocity of the car in m/s";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter Real cd1=0.75 "The drag coefficient of the sports car";
parameter SI.Area s1=1.4 "The frontal area of the car";
parameter SI.Velocity u1=300/3.6 "The velocity of the car in m/s";

//variable section
SI.Force d "The total drag on the car";
SI.Power p "The power of the car";
Real p_kW(unit = "kW") "The power required in kiloWatts";
Real p_hp(unit = "hp")"The power required in horse power";
SI.Force d1 "The total drag on the car";
SI.Power p1 "The power of the car";
Real p1_kW(unit = "kW") "The power required in kiloWatts";
Real p1_hp(unit = "hp")"The power required in horse power";

//equation section
equation
d=cd*0.5*rho_air*u*u*s;
p=d*u;
p_kW=p/1000;
p_hp=p/745.6;
//therefore we can probably use only one cylinder
//the same exercise for a race car travelling at 300km/h and having a frontal area of 1.4 m^2.
//assuming a drag coefficient of 0.75 for a race car.
d1=cd1*0.5*rho_air*u1*u1*s1;
p1=d1*u1;
p1_kW=p1/1000;
p1_hp=p1/745.6;
end Ex8_13;
//===================================================================
