//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.14 Page 288
  //Title: Vortex shredding frquency of a flagpole
  //===================================================================
model Ex8_14
import SI=Modelica.SIunits;

//parameter section
SI.Length d=0.3 "The diameter of the flagpole";
parameter SI.Velocity u=35 "The velocity of wind";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter Real mu_air(unit = "Ns/m2")=1.81*10^(-5) "The dynamic viscosity of air";

//variable section
Real Re "The reynolds mnumber of the flow";
Real f(unit = "Hz") "The vortex shredding frequency of a flag pole";
Real st "The strouhal number";

//equation section
equation
Re=rho_air*u*d/mu_air;
//using this value in figure 8.27 we find that st=0.27
st=0.27;
f=st*u/d;
end Ex8_14;
//===================================================================
//error in the value: in the book, the value of Re has been rounded off to 0.7*10^6. Hence there is a
//a change in the value of frequency from f=27 hertz (as given in book) to f=31.5 hertz
