//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.16 Page 289
  //Title: Accoustic effects of vortex shredding
  //===================================================================
model Ex8_16
import SI=Modelica.SIunits;

//parameter section
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
parameter Real mu_air(unit = "Ns/m2")=1.81*10^(-5) "The dynamic viscosity of air";
parameter SI.Velocity u=50/3.6 "The velocity of air";
parameter SI.Length d=0.0065 "The wire diameter";

//variable section
Real Re "The Reynold's number for the flow of air";
Real st "The strouhal number";
Real f(unit = "Hz") "The frequency of the vortex shredding";

//equation section
equation
Re=rho_air*u*d/mu_air;
//from the figure 8.27 the strouhal number is 0.21
st=0.21;
f=st*u/d;
end Ex8_16;
//===================================================================
//Error in the value:the frequency value through simulation= 448.78 Hz
// value given in the book f=449 Hz
