//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.18 Page 294
  //Title: Lift of a 2D flat plate
  //===================================================================
model Ex8_18
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//value of pi
SI.Length l=3.5 "The chord of a carpet roof";
//the span is assumed to be very wide i.e. infinity
SI.Velocity u=20/3.6 "The lift per unit span";
parameter Real a(unit = "degree")=5 "The angle at which the wind blows";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";

//variable section
Real cl "The drag due to lift";
SI.Force f "The lift per unit span";

//equation section
equation
//for this case we use the equation 8.90
cl=2*pi*a*pi/180;//note that a is calculated in radians
//since it is lift per unit span area can be taken for 1 metre wide
f=cl*0.5*rho_air*u*u*l;
end Ex8_18;
//===================================================================
