//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.20 Page 305
  //Title: Lift of a 3D plate
  //===================================================================
model Ex8_20
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//value of pi
  
//parameter section
parameter SI.Length c=3.5 "The chord of carport roof";
parameter SI.Length b=10 "The span of the roof";
parameter SI.Velocity v=20/3.6 "The velocity of the wind blowing";
parameter Real a(unit "Degree")=5 "The angle at which the wind blows";
parameter Real rho_air(unit = "kg/m3")=1.2 "The density of air";
  
//variable section
Real cl "The lift coefficient";
SI.Force l "The lift of the roof";
Real ar "The aspect ratio of the roof";
Real cdi "The induced drag cofficient";
SI.Force di "The induced drag force";
  
//equation section
equation
//from the equation 8.101 we approximate the 3D lift slope
cl=2*pi*5*pi/180/(1+(2*c/b)); 
//to calculate the lift of the roof 
l=cl*0.5*rho_air*v*v*c*b;
//to calculate the induced drag coefficient we use the equation 8.102 
//to find the aspect ratio
ar=b/c;
cdi=1/(pi*ar)*cl*cl;
di=cdi*0.5*rho_air*v*v*b*c;
//still some more is there 
end Ex8_20;
//===================================================================
