//Joseph Katz, Introductory Fluid Mechanics, Cambridge University Press, 2010
  //Chapter-8:High Reynolds Number flow over Bodies (Incompressible)
  //Example: 8.23 Page 310
  //Title: The need for high-lift devices
  //===================================================================
model Ex8_23
import SI=Modelica.SIunits;
final constant Real pi=2*Modelica.Math.asin(1.0);//value of pi

//parameter section
parameter SI.Mass m=250*1000 "The mass of the 747 jet";
parameter SI.Length b=64.4 "The wingspan of the wing";
parameter SI.Area s=541 "The wing area";
parameter SI.Length c=8.4 "The average chord length";
parameter Real rho_air(unit = "kg/m3")=1.1 "The density of air";
parameter SI.Velocity u=600/3.6 "The velocity of air in metres per second";
parameter SI.Acceleration g=9.8 "The acceleration due to gravity";
parameter SI.Velocity u1=220/3.6 "The velocity in the second case";

//variable section
Real cl "The lift coefficient";
Real ar "The aspect ratio of the wing";
Real cla "The lift slope of the wing";
Real att "The angle of attack";
Real cl_2 "The lift coefficient when flaps are not used";
Real att_2 "The angle of attack in the second case";

//equation section
equation
cl=m*g/(0.5*rho_air*u*u*s);
ar=b*b/s;
//the lift slope
cla=2*pi/(1+2/(ar));
//from eq 8.100 we can estimate the airplane angle of attack 
att=cl/cla*180/pi;
//the same calculations is repeated for a landing speed of 220 km/h and assume that flaps are not used.
cl_2=m*g/(0.5*rho_air*u1*u1*s);
att_2=cl_2/cla*180/pi;
//in both cases the angle of attack is too high and the plane has to use flaps for landing.
end Ex8_23;
//===================================================================
