// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-1: Introduction
//Example: 1.3 Page 17
//Title: Multimode Heat Transfer
//===================================================================
//Note: The below problem is linked to Example 1.2 

model Ex1_3

//=============
// Variable Section 

Real Ti(unit ="C")"Inside plate temperature";
Real qcond(unit = "W")" Heat transfer rate due to conduction";
Real deltaT(unit = "C")"Temperature difference across the plate";


//=============
// Parameter Section 

parameter Real qconv(unit = "kW")= 2.156" Heat transfer rate due to convection(obtained from Example:1.2)";
parameter Real T_plate(unit = "C")=250"Outside plate temperature(obtained from Example1.2)";
parameter Real qrad(unit = "W") = 300"Heat transfer rate due to radiation";
parameter Real deltax(unit = "cm")=2"Thickness of carbon steel plate";
parameter Real A(unit ="m^2")= 0.375"Area of the plate (obtained from Example1.2)";

//Note : The value of k is taken from Table 1.1(Page -6)
parameter Real k(unit = "W/mC")=43" Thermal conductivity of carbon steel";


//=============
// Equation Section 

equation
qcond = (qconv*1000) +qrad;//Calculation of conduction heat transfer rate
//Multiplication of Q by 1000 for conversion to W from kW

//Calculation of inside temperature
deltaT = T_plate-Ti;
qcond = ((-k * A * (deltaT))/(deltax*0.01));
//Multiplication of b by 0.01 for conversion to m from cm


end Ex1_3;
//========================================================================
