// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-1: Introduction
//Example: 1.5  Page 18
// Title: Radiation Heat Transfer
//===================================================================
model Ex1_5


//=============
// Variable Section 

Real q_A(unit= "kW/m^2")"Heat flux due to radiation";

//=============
// Parameter Section 

parameter Real T_1(unit ="C")=800"Temperature of plate 1";
parameter Real T_2(unit ="C")=300"Temperature of plate 2";
parameter Real sigma(unit ="W/m^2.K^4")=5.669E-8"Stefan-Boltzman constant";

//=============
// Equation Section 

equation
q_A = sigma*(((T_1+273)^4)-((T_2+273)^4))*0.001;
//Note: Multiplication of q by 0.001 to covert to kW

end Ex1_5;
//===================================================================
