// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.10 Page 548
// Title: Off-Design Calculation of Exchanger in Example 10-4
//===================================================================
// Note: The below problem is linked to Example 10.4
model Ex10_10

//=============
// Variable Section 
Real m_h(unit="kg/min")"Mass flow rate of oil";

Real Tw_exit(unit="C")"Exit water temperature";
Real deltaT_cold(unit="C")"Cold water temperature difference";

Real q(unit="kW")"Heat transfer rate";

Real NTU_max;

//Capacity rates
Real C_min, C_max;

//=============
// Parameter Section 
parameter Real m_c(unit="kg/min")=40"Mass flow rate of water";
parameter Real Tw_in(unit="C")=35"Inlet temperature of water";
parameter Real Tw_out(unit="C")=75"Outlet temperature of water";

parameter Real c_h(unit="kJ/kg.C")=1.9"Specific heat of oil";
parameter Real c_c(unit="J/kg.C")=4180"Specific heat of water";

parameter Real Toil_in(unit="C")=110"Inlet temperature of oil";
parameter Real Toil_out(unit="C")=75"Outlet temperature of oil";

parameter Real U(unit="W/m^2.C")=320"Overall heat transfer coefficient";
parameter Real A(unit="m^2")=15.82"Heat transfer area";

parameter Real e=0.744"Effectiveness Factor";
//=============
// EquationSection 
equation
m_h = (m_c*c_c*(Tw_out - Tw_in));

//Calculation of capacity rates

C_min = (m_c/60)* c_c;

C_max = (m_h/60)* c_h;

NTU_max = (U*A)/(C_min);

//From Table 10_3 the value of effectiveness factor is obtained 

e = (deltaT_cold)/(Toil_in-Tw_in);

//Calculation of exit water temperature
Tw_exit = Tw_in + deltaT_cold;

//Calculation of heat transfer rate
q = (m_c/60)* c_c*deltaT_cold*1E-3;

end Ex10_10;
//======================================================================== 
