// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.12  Page 550
// Title: Comparison of Single- or Two-Exchanger Options
//===================================================================
model Ex10_12
//=============
// Variable Section 
Real e_h;

//Capacity rates
Real m_h_c_h;

Real A;

//=============
// Parameter Section 
parameter Real m_c(unit="kg/s")=1.25"Mass flow rate of water";
parameter Real c_c(unit="J/kg.C")=4180"Specific heat of water";

parameter Real Tw_in(unit="C")=35"Inlet temperature of water";
parameter Real Tw_out(unit="C")=80"Outlet temperature of water";

parameter Real Toil_in(unit="C")=150"Inlet temperature of oil";
parameter Real Toil_out(unit="C")=85"Outlet temperature of oil";

parameter Real U(unit="W/m^2.C")=850"Overall heat transfer coefficient";
parameter Real NTU_max =1.09;

//=============
// Equation Section 
equation

m_c*c_c*(Tw_out - Tw_in) = m_h_c_h*(Toil_in- Toil_out);

e_h = (Toil_in - Toil_out)/(Toil_in - Tw_in);

//From Table 10.4 NTU_max = 1.09  for Cmin/Cmax = 0.692

A = NTU_max *(m_h_c_h/U);

end Ex10_12;
//======================================================================
