// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.13 Page 552
// Title: Shell-and-Tube Heat Exchanger as air heater
//===================================================================
model Ex10_13
//=============
// Variable Section 
Real Toil_out(unit="C")"Exit temperature of air";

Real C"Ratio of Capacity rate";

Real e"Effectiveness";
Real NTU"Number of transfer units";

Real A(unit="m^2")"Area of the exchanger";
//=============
// Parameter Section 
parameter Real Toil_in(unit="C")=100"Inlet temperature of oil";

parameter Real ma(unit="kg/s")=2"Mass flow rate of air";
parameter Real Ta_in(unit="C")=20"Inlet temperature of air";
parameter Real Ta_out(unit="C")=80"Outlet temperature of air";

parameter Real c_o(unit="J/kg.C")=2100"Specific heat of oil";
parameter Real cp_a(unit="J/kg.C")=1009"Specific heat of air";

parameter Real mo(unit="kg/s")=3"Mass flow rate of oil";

parameter Real U(unit="W/m^2.C")=200"Overall heat transfer coefficient";

//=============
// Equation Section 
equation
//Heat Balance
mo*c_o*(Toil_in- Toil_out) = ma*cp_a*(Ta_out - Ta_in);

C = (ma*cp_a)/(mo*c_o);

//Calculation of the heat exchanger effectiveness
e = (Ta_out - Ta_in)/(Toil_in - Ta_in);

//Calculation of NTU
//NTU =  -((1+(C^2)))^ (-0.5)  * log((2/e  -1 - C  -((1+(C^2)))^(-0.5))/(2/e  -1 - C  +((1+(C^2)))^(-0.5)));

NTU= -(1+C^2)^(-0.5) * log(((2/e)-1-C-((1+C^2)^(0.5)))/((2/e)-1-C+((1+C^2)^(0.5))));

//Calculation of the area of the exchanger
A = NTU *(ma*cp_a)/U;

end Ex10_13;
//======================================================================== 
