package Ex10_15

// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education
//Chapter-10: Heat Exchangers
//Example: 10.15.a Page 553
// Title: Cross-Flow Exchanger as Energy  Conservation Device
//===================================================================

  model Ex10_15_a
 
 //=============
 // Variable Section
 Real delta_Th(unit="C")"Temperature difference";

Real e"Heat exchanger Effectiveness";

Real N"Number of transfer units ";

Real A(unit="m^2")"Area of the exchanger";

//=============
// Parameter Section

parameter Real q(unit="kW")=210"Heat transfer required";

parameter Real m_h(unit="kg/min")=1200"Mass flow rate of atmospheric air";

parameter Real c_h(unit="J/kg.C")=1005"Specific heat of air";

parameter Real Ta_in(unit="C")=25"Inlet temperature of atmospheric air";
parameter Real Th_in(unit= "C")=0"Inlet temperature of outside air";
parameter Real U(unit="W/m^2.C")=30"Overall heat transfer coefficient";

//=============
// Equation Section
equation 

delta_Th = (q*1000)/((m_h/60)*c_h);


e = delta_Th/(Ta_in - Th_in);

//Calculation of Number of Transfer Units
e = 1- exp((N^0.22)*(exp(-N^(0.78))-1));

//Calculation of Area of the heat exchanger
N = (U*A)/((m_h/60)*c_h);

end Ex10_15_a;

//========================================================================
// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education
//Chapter-10: Heat Exchangers
//Example: 10.15.b Page 553
// Title: Cross-Flow Exchanger as Energy  Conservation Device: Flow reduced by 50 %/===================================================================

model Ex10_15_b
 //=============
 // Variable Section
 Real delta_T(unit="C")"Temperature difference";

Real C_min_new(unit="W/C")"Heat capacity";

Real N"Number of transfer units ";

Real e"Heat exchanger Effectiveness";

Real q(unit="kW")"Heat transfer rate";

//=============
// Parameter Section

parameter Real A(unit="m^2")=536"Area of the exchanger obtained from 5.10.a";
parameter Real C_min(unit="W/C") = 20100"Heat capacity";
parameter Real m_h(unit="kg/min")=1200"Mass flow rate of atmospheric air";

parameter Real c_h(unit="J/kg.C")=1005"Specific heat of air";

parameter Real Ta_in(unit="C")=25"Inlet temperature of atmospheric air";
parameter Real Th_in(unit= "C")=0"Inlet temperature of outside air";
parameter Real U(unit="W/m^2.C")=30"Overall heat transfer coefficient";

//=============
// Equation Section
equation 

C_min_new = C_min *0.5;


N = (U*A)/(C_min_new);

//Calculation of Effectiveness Factor
e = 1- exp((N^0.22)*(exp(-N^(0.78))-1));

//Calculation of Temperature Difference
delta_T= e *(Ta_in - Th_in);

//Calculation of heat transfer rate
q = C_min_new *delta_T*0.001;

end Ex10_15_b;


//=========================================================
// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education
//Chapter-10: Heat Exchangers
//Example: 10.15.c Page 554
// Title: Cross-Flow Exchanger as Energy  Conservation Device: U varies with (mass flow rate)^0.8
//===================================================================

model Ex10_15_c

//=============
// Variable Section

Real delta_T(unit="C")"Temperature difference";

Real C_min_new(unit="W/C")"Heat capacity";

Real N"Number of transfer units ";

Real e"Heat exchanger Effectiveness";

Real q(unit="kW")"Heat transfer rate";

//=============
// Parameter Section

parameter Real A(unit="m^2")=536"Area of the exchanger obtained from 5.10.a";
parameter Real C_min(unit="W/C") = 20100"Heat capacity";
parameter Real m_h(unit="kg/min")=1200"Mass flow rate of atmospheric air";

parameter Real c_h(unit="J/kg.C")=1005"Specific heat of air";

parameter Real Ta_in(unit="C")=25"Inlet temperature of atmospheric air";
parameter Real Th_in(unit= "C")=0"Inlet temperature of outside air";

//=============
// Equation Section
equation 

C_min_new = C_min *0.5;


N =0.8*(C_min_new/C_min)^(-0.2);

//Calculation of Effectiveness Factor
e = 1- exp((N^0.22)*(exp(-N^(0.78))-1));

//Calculation of Temperature Difference
delta_T= e *(Ta_in - Th_in);

//Calculation of heat transfer rate
q = C_min_new *delta_T*0.001;

end Ex10_15_c;
//===============================================================

end Ex10_15;
//================================================================
