// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.3 Page 527
// Title: Influence of Fouling Factor
//===================================================================
//Note : The below problem is linked to Example 10_2
model Ex10_3
//=============
// Variable Section 
Real h_dirty(unit="W/m^2.C")"Dirt heat transfer coefficient";
Real Reduction(unit="%")"Percentage reduction ";
//=============
// Parameter Section 
parameter Real h_clean(unit="W/m^2.C")=1961"Clean heat transfer coefficient";
parameter Real Rf(unit="m^2.C/W")=0.0002"Fouling factor";

//=============
// Equation Section 
equation
Rf = (1/h_dirty)-(1/h_clean);

//Perecentage reduction in heat transfer coefficient
Reduction = ( (h_clean- h_dirty)/h_clean)*100;

end Ex10_3;
//========================================================================
