// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.4 Page 536
// Title: Calculation of Heat-Exchanger Size from Known Temperatures
//===================================================================
model Ex10_4
//=============
// Variable Section 
Real q(unit="kW")"Heat transfer rate";
Real A(unit="m^2")"Heat transfer area";

Real delta_Tm(unit="C")"Log mean temperature difference";

//=============
// Parameter Section 
parameter Real mw(unit="kg/min")=68"Mass flow rate of water";
parameter Real Tw_in(unit="C")=35"Inlet temperature of water";
parameter Real Tw_out(unit="C")=75"Outlet temperature of water";

parameter Real Cp_oil(unit="kJ/kg.C")=1.9"Specific heat of oil";
parameter Real Cp_w(unit="J/kg.C")=4180"Specific heat of water";

parameter Real Toil_in(unit="C")=110"Inlet temperature of oil";
parameter Real Toil_out(unit="C")=75"Outlet temperature of oil";

parameter Real U(unit="W/m^2.C")=320"Overall heat transfer coefficient";

//=============
// Equation Section 
equation

//Calculation of heat transfer rate
q =( mw*Cp_w*(Tw_out - Tw_in))/60*1E-3;

//Calculation of Log mean temperature difference
delta_Tm = ((Toil_in - Tw_out)-(Toil_out - Tw_in))/log((Toil_in - Tw_out)/(Toil_out - Tw_in));

//Calculation of area
A = (q*1000)/(U*delta_Tm);

end Ex10_4;
//======================================================================== 
