// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-10: Heat Exchangers
//Example: 10.7 Page 539
// Title: Cross-Flow Exchanger with One Fluid Mixed
//===================================================================
model Ex10_7
//=============
// Variable Section 

Real q(unit="kW")"Heat transfer rate";

Real delta_Tm(unit="C")"Log mean temperature difference";

//Parameters used to determine the correction factor
Real R,S;

Real A(unit="m^2")"Heat transfer area";
//=============
// Parameter Section 
parameter Real ms(unit="kg/s")=5.2"Mass flow rate of steam";
parameter Real c(unit="kJ/kg.C") =1.9"Specific heat of oil";

parameter Real t1(unit="C")=15"Inlet temperature of oil";
parameter Real t2(unit="C")=85"Outlet temperature oil";

parameter Real T1(unit="C")=130"Inlet temperature of steam";
parameter Real T2(unit="C")=110"Outlet temperature  steam";

parameter Real U(unit="W/m^2.C")=275"Overall heat transfer coefficient";

parameter Real cs(unit="kJ/kg.C") =1.86"Specific heat of steam";

parameter Real F=0.97"Correction Factor";

//=============
// Equation Section 
equation

//Calculation of heat transfer rate
q = (ms* cs*1000*(T1- T2))*1E-3;

//Calculation of Log mean temperature difference
delta_Tm = ((T1 - t2)-(T2 - t1))/log((T1 - t2)/(T2 - t1));

//From Figure 10.11
R = (T1 - T2)/(t2 - t1);

S = (t2 - t1)/(T1 - t1);

// For the above values from Figure 10.11 correction factor F =0.97

//Heat transfer area
A = (q*1000)/(U*F*delta_Tm);

end Ex10_7;
//======================================================================== 
