// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-11: Mass Transfer
//Example: 11.1 Page 589
// Title: Diffusion Coefficient for Carbon Dioxide
//===================================================================
model Ex11_1

//=============
// Variable Section 
Real D(unit="cm^2/s")"Diffusion Coefficient for CO2";

//=============
// Parameter Section 
parameter Real T(unit="K") =298"Total temperature of the system";
parameter Real P(unit="Pa") =101325"Total pressure of the system";
parameter Real V_CO2 = 34"Molecular volume of CO2";
parameter Real V_air = 29.9"Molecular volume of air";
parameter Real M_CO2 =44"Molecular Weight of carbon dioxide";
parameter Real M_air = 28.9"Molecular Weight of air";

//=============
// Equation Section
equation

//Calculation of Diffusion Coefficient using Gilliland Equation
D = 435.7 * ((T^1.5)/((P)*((V_CO2^(1/3))+(V_air^(1/3)))^2)) * sqrt((1/M_CO2 )+(1/M_air));

end Ex11_1;
//========================================================================
