// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-11: Mass Transfer
//Example: 11.3 Page 596
// Title: Wet-Bulb Temperature
//===================================================================
model Ex11_3

//=============
// Variable Section 
Real T_infinity(unit="C")"Temperature of dry air";
Real rho;
Real rhow(unit="kg/m^3")"Density of water evaporated";

//=============
// Parameter Section
parameter Real rho_g(unit="kg/m^3") = 2107"Saturated concentration for free stream at 18.3 C";
parameter Real Rw(unit="cm^3 kPa/Kmol")=8315"Gas Constant";
parameter Real R(unit="J/kg.K")=287"Gas Constant";
parameter Real Tw(unit="C")=18.3"Temperature measured by the thermometer";
parameter Real p(unit="Pa") =101325"Atmospheric Pressure";
parameter Real Mw=18"Molecular weight of water";
parameter Real rho_infinity(unit="kg/m^3")=0"Density of the dry air";
parameter Real Cp(unit="kJ/kg.C")=1.004"Specific Heat at the temperature measured by thermometer";
parameter Real Le=0.845"Lewis Number";
parameter Real hfg(unit="MJ/kg")=2.456;

//=============
// Equation Section
equation
rhow = (rho_g*Mw)/(Rw*(Tw+273));
rho = (p)/(R*(Tw+273));
//Calculation of Dry air Temperature
//Note:Multiplication of hfg by1000000 to convert from MJ to J
(hfg*1000000*(rhow-rho_infinity)) = (rho*Cp*1000*(Le)^(2/3))*(T_infinity - Tw);

end Ex11_3;
//========================================================================
