// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady State Conduction : One Dimension
//Example: 2.12 Page 60
//Title: Influence of Contact Conductance on Heat Transfer
//===================================================================
model Ex2_12

//=============
// Variable Section 

Real q(unit = "W")"Overall heat flow";
Real delta_Tc(unit ="C")"Temperature Difference across the contact";
Real sigmaR_th(unit = "C/W")"Total thermal resistance";
Real Rc(unit = "C/W")"Contact resistance(Convection)";
Real Rth(unit = "C/W")"Contact resistance";
Real A(unit = "m^2")"Cross sectional area of the bar";

//=============
// Parameter Section 
parameter Real d(unit = "cm")= 3"Diameter of the steel bar";
parameter Real L(unit = "cm")=10"Length of the steel bar";
parameter Real delta_T(unit ="C")=100"Temperature Difference";

//Note : The following data are taken from Table :2.2
parameter Real k (unit="W/m.C")=16.3"Thermal conductivity of the tube";
parameter Real hc (unit = "W/m^2.C")=1893.93"Convection Heat transfer coefficient";

//=============
// Equation Section
equation 
A = (3.14/4)*d*d*0.01*0.01;//Calculation of cross scetional area of the bar
//Note: Multiplication of d by 0.01 to convert to m from cm
Rth = (L*0.01)/(k*A);
//Note:Multiplication of L by 0.01 to convert to m from cm
Rc = 1/(hc*A);
sigmaR_th = (2*Rth) + Rc;//Calculation of total thermal resistance
//Note: Multiplication of Rth by 2 since there are two bars
q = (delta_T)/(sigmaR_th);//Calculation of overall heat flow
delta_Tc = (Rc/sigmaR_th)*delta_T;//Calculation of temperature difference across the contact

end Ex2_12;
//===================================================================
