// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-2: Steady-state Conduction-One Dimesnsion
//Example: 2.4 Page 38
// Title: Cooling Cost Savings with Extra Insulation

//===================================================================
model Ex2_4

//=============
// Variable Section 
Real q_fibre_glass_260(unit="W")"Heat gain for 260 mm fibre glass";
Real q_fibre_glass_159(unit="W")"Heat gain for 159 mm fibre glass";

Real q_woodstud(unit="W")"Heat gain for wood stud";

Real q_s(unit="W")"Savings due to extra insulation";
Real Power_Required(unit="W")"Extra electric power required";

Real Cost_saving_fibreglass(unit="dollars")"Cost savings due to extra power for fibreglass";
Real Cost_saving_fibreglass_month(unit="dollars")"Cost savings due to extra power per month";

Real Heating_Load_compare(unit="W")"Comparision of heating load with that of fibre-glass";

//=============
// Parameter Section 
parameter Real A(unit="m^2")=300"Total wall surface area";
parameter Real Cost(unit="dollars")=0.15"Electricity cost per kW";
parameter Real delta_T(unit="C")=20"Temperature difference";

parameter Real q_aircond(unit="kW")=1"Energy consumed by the air conditioner";
parameter Real q_coolingwater(unit="kW")=4"Energy supplied by the cooling water";

parameter Real U_fibre_glass_260(unit="W/m^2.C")=0.17"Heat transfer coefficient for 260 mm fibre glass";
parameter Real U_fibre_glass_159(unit="W/m^2.C")=0.31"Heat transfer coefficient for 159 mm fibre glass";

parameter Real U_stud(unit="W/m^2.C")=1.85"Heat transfer coefficient for wooden stud from Table 2.2";

//=============
// Equation Section 
equation

//Calculation of heat gain for different constructions
q_fibre_glass_260 = U_fibre_glass_260*A*delta_T;

q_fibre_glass_159 = U_fibre_glass_159*A*delta_T;

//Calculation of saving due to extra insulation
q_s = q_fibre_glass_159 - q_fibre_glass_260;

//Electric power required 
Power_Required = q_s*(q_aircond/q_coolingwater);

//Calculation of cost savings
Cost_saving_fibreglass = (Power_Required*0.001)*Cost;

//Calculation of cost savings per month
Cost_saving_fibreglass_month = Cost_saving_fibreglass *10*23;

//Note: 10 indicated assumed operation of 10 hours per day
//           23 indicates the approximate days per month

//Comparision to Numeber-4 in Table 2.2 value of U=2.85 for wood stud wall
q_woodstud = U_stud *A*delta_T;

//Comparision of savings
Heating_Load_compare = q_woodstud -(q_fibre_glass_260);

end Ex2_4;
//========================================================================
