// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education
//Chapter-2: Steady State Conduction: One Dimension
//Example: 2.5 Page 39
// Title: Overall heat transfer coefficient for a tube
//===================================================================
  model Ex2_5
//=============
// Variable Section 
  Real q(unit = "W") "Heat transfer rate";
  Real Uo(unit = "W/m^2.C") "Overall heat transfer coefficient";
  Real Ri(unit = "C/W") "Inside convection resistance";
  Real Ro(unit = "C/W") "Outside convection resistance";
  Real Rt(unit = "C/W") "Resistance offered by the tube";
  Real delta_T(unit = "C") "Temperature Difference";
  Real do(unit = "m") "Outer Diameter";
  Real Ai(unit = "m^2") "Inside tube area";
  Real Ao(unit = "m^2") "Outside tube area";
  Real Rtot(unit = "C/W") "Total thermal resistance";
  
  
  //=============
  // Parameter Section
  parameter Real L(unit = "m") = 1 "Tube Length";
  parameter Real di(unit = "cm") = 2.5 "Inner Diameter";
  parameter Real t(unit = "mm") = 0.8 "Wall thickness of the tube";
  parameter Real hi(unit = "W/m^2.C") = 3500 "Inside heat transfer coefficient";
  parameter Real ho(unit = "W/m^2,C") = 7.6 "Outside heat transfer coefficient";
  parameter Real T_i(unit = "C") = 50 "Inside temperature";
  parameter Real T_o(unit = "C") = 20 "Surrounding temperature";
  parameter Real k(unit = "W/m.C") = 16 "Thermal conductivity of the tube";
  
  
  //=============
  // Equation Section
equation
  delta_T = T_i - T_o;
  Ai = 3.14 * di * 0.01 * L;
  //Calculation of outer diameter
//Note : Multiplication of di by 0.01 to convert to m from cm
//          Multiplication of t by 0.001 to convert to m from mm
  do = di * 0.01 + 2 * t * 0.001;
//Calculation of outside tube area
  Ao = 3.14 * do * L;
//Calculation of inside convection resistance
  Ri = 1 / (Ai * hi);
//Calculation of outside convection resistance
  Ro = 1 / (Ao * ho);
//Calculation of thermal resistance of tube
  Rt = log(do / (di * 0.01)) / (2 * 3.14159 * k * L);
//Calculation of total thermal resisitance
  Rtot = Ri + Ro + Rt;
//Calculation of overal heat transfer coefficient
  Uo = 1 / (Ao * Rtot);
//Calculation  of heat transfer rate
  q = Uo * Ao * delta_T;

end Ex2_5;
//========================================================================
