// Holman J. P. Heat Transfer, 10th Edn., McGraw Hill Higher Education 

//Chapter-4: Unsteady State Conduction 
//Example: 4.5 Page 159
// Title:  Sudden Exposure of Semi-Infinite Slab to Convection
//===================================================================

//Note : The below problem is linked to Example:4.4
model Ex4_5
//=============
//Variable Section
Real y,y1,y2;

//=============
// Parameter Section

parameter Real tow(unit="s")=3000"Time required for the temperature to reach 120 C";
parameter Real h(unit="W/m^2.K")=525"Heat Transfer Coefficient of the covection environment";
parameter Real alpha(unit = "m^2/s")= 8.4E-5"Thermal Diffusivity of Aluminium";
parameter Real k(unit = "W/m.C")= 215"Thermal Conductivity of Aluminium";
parameter Real x(unit="cm")= 4"Depth at which time is computed for a temperature of 120 C";
parameter Real Ti(unit = "C")= 200"Initial Temperature of the slab";
parameter Real T_infinity(unit = "C")= 70"Final Temperature of the slab";
parameter Real T(unit = "C")= 120"Temperature at a depth of 4cm from the slab";
//=============
// Equation Section
equation

(T-Ti)/(T_infinity-Ti) = y;
//Note : From th graph in Page:  Figure:4.5 "Temperature distribution in the semi-infinite solid with convection boundary condition."
//The values of (x)/(4*alpha*tow)^0.5 and h*((alpha*tow)^0.5)/k are obtained for corresponding values of y and checked for equivalence.

//For tow=3000s;
y1 = (x*0.01)/((4*alpha*tow)^0.5);
y2 = (h*((alpha*tow)^0.5))/k;

end Ex4_5;
//==================================================================
